/* Test code for stack class */
#include <iostream>
#include <cstring>
#include "stack.hpp"
using namespace std;

class Test {
public:
  Test(char *m) { 
    cout << "Created: " << m << endl;
    message = (char *)malloc(strlen(m)+1);
    strcpy(message, m);
  }

  Test(const Test &t) {
    cout << "Copied: " << t.message << endl;    
    message = (char *)malloc(strlen(t.message)+1);
    strcpy(message, t.message);
  }

  Test &operator= (const Test& t) {
    cout << "Assignment: erase " << message << ", replace with " << t.message << endl;    
    free(message);
    message = (char *)malloc(strlen(t.message)+1);
    strcpy(message, t.message);
    return *this;
  }

  ~Test() { 
    cout << "Destroyed: " << message << endl;
    free(message); 
  }

  friend ostream &operator<< (ostream &out, const Test& t);

private:
  char *message;
};

ostream &operator<< (ostream &out, const Test& t) {
  out << t.message;
  return out;
}

int main()
{
  Stack<int> is;
  is.push(1);
  is.push(2);
  cout << is.pop() << endl;
  cout << is.pop() << endl << endl;

  Stack<Test> ts;
  ts.push("M1");
  ts.push("M2");
  cout << ts.pop() << endl;
  cout << ts.pop() << endl;
}
