#ifndef ULAPACK_MATRIX_TYPEDEFS_HPP_
#define ULAPACK_MATRIX_TYPEDEFS_HPP_

namespace ulapack {
	namespace ublas = boost::numeric::ublas;
    
	template <size_t Size, class F = ublas::row_major>
	struct Fixed {
		typedef ublas::matrix<double, F, ublas::bounded_array<double, Size*Size> > Matrix;
		typedef ublas::vector<double, ublas::bounded_array<double, Size> > Vector;
	};

	template <class F = ublas::row_major>
	struct Flex {
		typedef ublas::matrix<double, F> Matrix;
	};

	typedef Flex<>::Matrix Matrix;
	typedef ublas::vector<double> Vector;

} // namespace ulapack

#endif 
