#include <boost/random.hpp>

namespace {

class Random {
public: 
	Random() : rng(), gen_uniform(rng), gen_normal(rng,norm) {}

	double uniform() { return gen_uniform(); }
	double normal() { return gen_normal(); }

	void seed(boost::uint32_t s) { 
		rng.seed(s); 
		boost::uniform_01<boost::mt19937, double> tmp(rng); 
		gen_uniform = tmp; 
	}

private:
	boost::mt19937 rng;
	boost::uniform_01<boost::mt19937, double> gen_uniform;
	boost::normal_distribution<> norm;
	boost::variate_generator<boost::mt19937, boost::normal_distribution<> > gen_normal; 
};

} // unnamed namespace
