
#ifndef ULAPACK_SAMPLING_HPP_
#define ULAPACK_SAMPLING_HPP_

namespace ulapack {
	namespace ublas = boost::numeric::ublas;

	class GaussLikelihood {
	public:
		GaussLikelihood(const Vector &p, const Matrix &P);
		double likelihood(const Vector &x) const;
		double loglikelihood(const Vector &x) const;

	private:
		double compute_numerator(const Vector &x) const;

		static const double PI; // constant pi
		double C;				// likelihood normalising constant
		Matrix Pfi;				// inverse of Cholesky decomposed covariance
		const Vector &gmean;	// store Gaussian mean 
	};

}

#endif
