#include <boost/numeric/ublas/matrix.hpp>

#include <vector>
#include <iostream>

#include "cholesky.hpp"
#include "printmatrix.hpp"

using namespace std;
using namespace boost::numeric::ublas;
using namespace ulapack;

int main() 
{
	//typedef matrix<double, row_major, bounded_array<double, 9> > Matrix;
	typedef matrix<double, column_major> Matrix;
	try {
		Matrix m( 3,3 );

		m(0,0) = 2.0;   
		m(0,1) = 1.0;   
		m(0,2) = 0.32;   
		m(1,0) = 1.0;  
		m(1,1) = 2.0;   
		m(1,2) = 1.0;   
		m(2,0) = 0.32;  
		m(2,1) = 1.0;   
		m(2,2) = 2.0;   

		cout << "Original matrix: " << endl;
		print_matrix(m);

#if 1  // Test Cholesky class
		ulapack::Cholesky<Matrix> c(m);

		cout << "Cholesky matrix: " << endl;
		print_matrix(c.chol());

		cout << "Inverse matrix: " << endl;
		print_matrix(c.inv());

		cout << "Determinant: " << c.det() << endl;

#else  // Test Cholesky stand-alone functions (demos a selection of the available interface)

		Matrix c = chol(m);
		cout << "Cholesky matrix: " << endl;
		print_matrix(c);

		cout << "Inverse matrix: " << endl;
		print_matrix(inv_pd(m));

		cout << "Inverse matrix (in-place version1): " << endl;
		Matrix tmp(m);
		inv_pd_inplace(tmp);
		print_matrix(tmp);

		cout << "Inverse matrix (in-place version2): " << endl;
		inv_chol_inplace(c);
		print_matrix(c);

		cout << "Determinant: " << det_pd(m) << endl;

#endif

	}
	catch (LapackError& e) {
		cout << "LapackError, INFO: " << e.get_info()
			<< " Message: " << e.what() << endl;
	}
	catch (exception& e) {
		cout << "Other Exception, Message: " << e.what() << endl;
	}
	catch (...) {
		cout << "Unknown Exception" << endl;
	}

}
