
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/io.hpp>

#include <vector>
#include <iostream>
#include <time.h>

#include "lufactor.hpp"
#include "printmatrix.hpp"

using namespace boost::numeric::ublas;
using namespace ulapack;
using namespace std;

int main( ) 
{
	try {
		typedef matrix<double, column_major> Matrix;
		Matrix m( 4,4 );

		//srand(time(0));

		for (int i=0; i<m.size1(); ++i)
			for (int j=0; j<m.size2(); ++j)
				m(i,j) = rand();

		cout << "Original matrix: " << endl;
		print_matrix(m);

#if 1 // test LU class
		LU<Matrix> lu(m);

		cout << "LU inverse: " << endl;
		print_matrix(lu.inv());

		cout << "LU determinant: " << lu.det() << endl;

#else // test LU stand-alone functions
		Matrix lu(m);
		ublas::vector<int> pivot;

		const char *status = (lufactor(lu, pivot)==false) ? "Singular" : "Non-singular";
		cout << status << " LU factorised matrix: " << endl;
		print_matrix(lu);

		Matrix x = inv(m);
		cout << "Inverse" << endl;
		print_matrix(x);

		cout << "LU determinant: " << det(m) << endl;
#endif

	}
	catch (LapackError& e) {
		cout << "LapackError, INFO: " << e.get_info()
			<< " Message: " << e.what() << endl;
	}
	catch (exception& e) {
		cout << "Other Exception, Message: " << e.what() << endl;
	}
	catch (...) {
		cout << "Unknown Exception" << endl;
	}

}
